<?php
namespace App\Http\Controllers\Admin;

use App\User;
use App\Models\{
    Subscriber
};

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Validator;

class NewsletterController extends Controller {

    public function __construct(){
        $this->middleware('auth:admin');
    }

    public function subscribers(Request $request){
        $search = '';
        $records = Subscriber::orderBy('id','DESC'); 
        if(isset($request->search) && $request->search!=""){
            $search = $request->search;
            $records = $records->where('email', 'like', '%'.$search.'%');
        }
        $rows = (isset($request->rows) && $request->rows!="") ? $request->rows: 10;
        $records = $rows=="all" ? $records->paginate(9999999)->withQueryString() : $records->paginate($rows)->withQueryString();

        return view('admin.newsletter.list',compact('records','search','rows'));
    }


    public function delete(Request $request,$id){
        $record=Subscriber::find($id);
        $record->delete();
        $request->session()->flash('success','Subscriber Deleted Successfully');
        return redirect()->route('admin.list_subscribers');
    }

    public function send_newsletter_form(){
        $users = User::select('id','name','email')->get();
        return view('admin.newsletter.send_newsletter_form',compact('users'));
    }
    public function submit_newsletter(Request $request){
        $validator=Validator::make($request->all(),[
                    'users'=>'required',
                    'heading'=>'required',
                    'description'=>'required',
        ]);
        if($validator->fails()) {
            return redirect()->back()->withInput()->withErrors($validator->errors());
        }
        else{
            $request->session()->flash('success','Newsletter sent Successfully');
            return redirect()->route('admin.list_subscribers');   
        }
    }
}
