<?php
namespace App\Http\Controllers\Admin;

use File;
use App\Models\News;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use Illuminate\Support\Facades\Validator;

class NewsController extends Controller {

    public function __construct(){
        $this->middleware('auth:admin');
    }

    public function index(Request $request){
        $search = '';$status = '';
        $records = News::orderBy('id','DESC'); 
        if(isset($request->search) && $request->search!=""){
            $search = $request->search;
            $records = $records->where('title_eng', 'like', '%'.$search.'%')
                                ->orWhere('description_eng', 'like', '%'.$search.'%')
                                ->orWhere('title_ar', 'like', '%'.$search.'%')
                                ->orWhere('description_ar', 'like', '%'.$search.'%');
        }
        if(isset($request->status) && $request->status!=""){
            $status = $request->status;
            $records = $records->where('status',$request->status);
        }
        $rows = (isset($request->rows) && $request->rows!="") ? $request->rows: 10;
        $records = $rows=="all" ? $records->paginate(9999999)->withQueryString() : $records->paginate($rows)->withQueryString();
        return view('admin.news.list',compact('records','search','rows','status'));
    }

    public function add(Request $request){
        return view('admin.news.add');
    }

    public function save_new_record(Request $request){
        $validator=Validator::make($request->all(),[
            'title_eng'=>'required|unique:news',
            'description_eng'=>'required',
            'title_ar'=>'required',
            'description_ar'=>'required',
            'image'=>'required|image'
        ]);
        if($validator->fails()) {
            return redirect()->back()->withInput()->withErrors($validator->errors());
        }
        else{
            $imageName = "news-image-".time().'.'.$request->image->getClientOriginalExtension();
            $result = $request->image->move(public_path('/admin/images/news_images'), $imageName);
            $record = News::create([
                'slug'=>Str::slug($request->title_eng, '-'),
                'title_eng'=>$request->title_eng,
                'description_eng'=>$request->description_eng,
                'title_ar'=>$request->title_ar,
                'description_ar'=>$request->description_ar,
                'status'=>1,
                'image'=>$imageName,
                'link'=>isset($request->link) ? $request->link : NULL
            ]);
            $request->session()->flash('success','Record created Successfully');
            return redirect()->route('admin.list_news');   
        }
    }

    public function changeStatus(Request $request){
        $record = News::find($request->id);
        $record->status = $request->status;
        $record->save();
        return true;
    }

    public function delete(Request $request,$id){
        $record=News::find($id);
        $record->delete();
        $request->session()->flash('success','Record Deleted Successfully');
        return redirect()->route('admin.list_news');
    }

    public function view(Request $request,$id){
        $record = News::find($id);
        return view('admin.news.view',compact('record'));
    }

    public function edit(Request $request,$id){
        $record = News::find($id);
        return view('admin.news.edit',compact('record','id'));
    }

    public function save_edit_record(Request $request){
        $validator=Validator::make($request->all(),[
                    'title_eng'=>'required',
                    'description_eng'=>'required',
                    'title_ar'=>'required',
                    'description_ar'=>'required',
                    'image'=>'nullable|image'
        ]);
        if($validator->fails()) {
            return redirect()->back()->withInput()->withErrors($validator->errors());
        }
        else{
            $record = News::find($request->id);
            $imageName = $request->old_image;
            if(isset($request->image) && !empty($request->image)){
                $imageName = "news-image-".time().'.'.$request->image->getClientOriginalExtension();
                $result = $request->image->move(public_path('/admin/images/news_images'), $imageName);
                if (File::exists(public_path('/admin/images/news_images/'.$request->old_image))) {
                    File::delete(public_path('/admin/images/news_images/'.$request->old_image));
                }
            }
            $record->image = $imageName;
            $record->slug = Str::slug($request->title_eng, '-');
            $record->title_eng = $request->title_eng;
            $record->description_eng = $request->description_eng;
            $record->title_ar = $request->title_ar;
            $record->description_ar = $request->description_ar;
            $record->link = isset($request->link) ? $request->link : NULL;
            $record->save();
            $request->session()->flash('success','Record updated Successfully');
            return redirect()->route('admin.list_news');   
        }
    }
}
