<?php
namespace App\Http\Controllers\Admin;

use App\Models\Faq;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Validator;

class FaqController extends Controller {

    public function __construct(){
        $this->middleware('auth:admin');
    }

    public function index(Request $request){
        $search = '';$status='';
        $records = Faq::orderBy('id','DESC'); 
        if(isset($request->search) && $request->search!=""){
            $search = $request->search;
            $records = $records->where('heading_eng', 'like', '%'.$search.'%')
                                ->orWhere('description_eng', 'like', '%'.$search.'%')
                                ->orWhere('heading_ar', 'like', '%'.$search.'%')
                                ->orWhere('description_ar', 'like', '%'.$search.'%');
        }
        if(isset($request->status) && $request->status!=""){
            $status = $request->status;
            $records = $records->where('status',$request->status);
        }
        $rows = (isset($request->rows) && $request->rows!="") ? $request->rows: 10;
        $records = $rows=="all" ? $records->paginate(9999999)->withQueryString() : $records->paginate($rows)->withQueryString();
        return view('admin.faq.list',compact('records','search','rows','status'));
    }

    public function add(Request $request){
        return view('admin.faq.add');
    }

    public function save_new_record(Request $request){
        $validator=Validator::make($request->all(),[
                    'heading_eng'=>'required',
                    'description_eng'=>'required|max:2500',
                    'heading_ar'=>'required',
                    'description_ar'=>'required|max:2500'
        ]);
        if($validator->fails()) {
            return redirect()->back()->withInput()->withErrors($validator->errors());
        }
        else{
            $record = Faq::create([
                'heading_eng'=>$request->heading_eng,
                'description_eng'=>$request->description_eng,
                'heading_ar'=>$request->heading_ar,
                'description_ar'=>$request->description_ar,
                'status'=>1,
            ]);
            $request->session()->flash('success','Faq created Successfully');
            return redirect()->route('admin.list_faq');   
        }
    }

    public function changeStatus(Request $request){
        $record = Faq::find($request->id);
        $record->status = $request->status;
        $record->save();
        return true;
    }

    public function delete(Request $request,$id){
        $record=Faq::find($id);
        $record->delete();
        $request->session()->flash('success','Faq Deleted Successfully');
        return redirect()->route('admin.list_faq');
    }

    public function view(Request $request,$id){
        $record = Faq::find($id);
        return view('admin.faq.view',compact('record'));
    }

    public function edit(Request $request,$id){
        $record = Faq::find($id);
        return view('admin.faq.edit',compact('record','id'));
    }

    public function save_edit_record(Request $request){
        $validator=Validator::make($request->all(),[
                    'heading_eng'=>'required',
                    'description_eng'=>'required|max:2500',
                    'heading_ar'=>'required',
                    'description_ar'=>'required|max:2500'
        ]);
        if($validator->fails()) {
            return redirect()->back()->withInput()->withErrors($validator->errors());
        }
        else{
            $record = Faq::find($request->id);
            $record->heading_eng = $request->heading_eng;
            $record->description_eng = $request->description_eng;
            $record->heading_ar = $request->heading_ar;
            $record->description_ar = $request->description_ar;
            $record->save();
            $request->session()->flash('success','FAQ updated Successfully');
            return redirect()->route('admin.list_faq');   
        }
    }
}
