<?php

namespace App\Http\Controllers\Admin;
use App\Models\{ 
    Course,Category
};

use App\Repositories\CourseRepository;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


class CourseController extends Controller {

    public function __construct(CourseRepository $course_repository){
        $this->course_repository = $course_repository;
        $this->middleware('auth:admin');
    }

    public function index(Request $request){
        $search = '';$status='';
        $records = Course::orderBy('id','DESC'); 
        if(isset($request->search) && $request->search!=""){
            $search = $request->search;
            $records = $records->where('name_eng', 'like', '%'.$search.'%')
                                ->orWhere('name_ar', 'like', '%'.$search.'%')
                                ->orWhere('about_course_eng', 'like', '%'.$search.'%')
                                ->orWhere('about_course_ar', 'like', '%'.$search.'%')
                                ->orWhere('venue_eng', 'like', '%'.$search.'%')
                                ->orWhere('venue_ar', 'like', '%'.$search.'%')
                                ->orWhere('prerequisites_eng', 'like', '%'.$search.'%')
                                ->orWhere('prerequisites_ar', 'like', '%'.$search.'%')
                                ->orWhere('package_includes_eng', 'like', '%'.$search.'%')
                                ->orWhere('package_includes_ar', 'like', '%'.$search.'%');
        }
        if(isset($request->status) && $request->status!=""){
            $status = $request->status;
            $records = $records->where('status',$request->status);
        }
        $rows = (isset($request->rows) && $request->rows!="") ? $request->rows: 10;

        $records = $rows=="all" ? $records->paginate(9999999)->withQueryString() : $records->paginate($rows)->withQueryString();

        return view('admin.courses.list',compact('records','search','rows','status'));
    }

    public function add(Request $request){
        $categories = Category::all();
        return view('admin.courses.add',compact('categories'));
    }

    public function edit(Request $request,$id){
        $record = Course::where('id',$id)->first();
        // print_r($record);die;
        $categories = Category::all();
        return view('admin.courses.edit',compact('record','categories'));
    }

    public function delete(Request $request,$id){
        return $this->course_repository->delete($request,$id);
    }

    public function view(Request $request,$id){
        $record = Course::where('id',$id)->first();
        return view('admin.courses.view',compact('record'));
    }
    
    public function save_new_record(Request $request){
        return $this->course_repository->save_new_record($request);
    }
    public function save_edit_record(Request $request){
        return $this->course_repository->save_edit_record($request);
    }
    public function changeStatus(Request $request){
        return $this->course_repository->changeStatus($request);
    }
}
