<?php

namespace App\Http\Controllers\Admin;
use App\Models\{
    Category
};
use Illuminate\Http\Request;
use App\Repositories\{
	CategoryRepository
};
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
class CategoryController extends Controller{
    
    public function __construct(CategoryRepository $category_repository){
    	$this->category_repository = $category_repository;
    }
    public function index(Request $request){
    	$search = '';$status='';
        $records = Category::orderBy('id','DESC'); 
        if(isset($request->search) && $request->search!=""){
            $search = $request->search;
            $records = $records->where('name_eng', 'like', '%'.$search.'%')
                               ->orWhere('name_ar', 'like', '%'.$search.'%');
        }
        if(isset($request->status) && $request->status!=""){
            $status = $request->status;
            $records = $records->where('status',$request->status);
        }
        $rows = (isset($request->rows) && $request->rows!="") ? $request->rows: 10;

        $records = $rows=="all" ? $records->paginate(9999999)->withQueryString() : $records->paginate($rows)->withQueryString();

        return view('admin.categories.list',compact('records','search','rows','status'));
    }
    public function changeStatus(Request $request){
        return $this->category_repository->changeStatus($request);
    }
    public function add(){
        $categoriesDropdown = $this->category_repository->getCategoriesDropdown();
        return view('admin.categories.add',compact('categoriesDropdown')); 
    }
    public function save_new_record(Request $request){
        return $this->category_repository->save_new_record($request);
    }
    public function view(Request $request,$id){
        $record = $this->category_repository->getCategoryById($id);
        return view('admin.categories.view',compact('record')); 
    }
    public function delete(Request $request,$id){
        return $this->category_repository->deleteCategory($request,$id);
    }
    public function edit(Request $request,$id){
        $record = $this->category_repository->getCategoryById($id);
        $categoriesDropdown = $this->category_repository->getCategoriesDropdown(array($id),array());
        return view('admin.categories.edit',compact('record','categoriesDropdown')); 
    }
    public function save_edit_record(Request $request){
        return $this->category_repository->save_edit_record($request);
    }
}