<?php
namespace App\Http\Controllers\Admin;

use File;
use App\Models\Banner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Validator;

class BannersController extends Controller {

    public function __construct(){
        $this->middleware('auth:admin');
    }

    public function index(Request $request,$type='home'){
        $search = '';$status = '';
        $records = Banner::where('type',$type)->orderBy('id','DESC'); 
        if(isset($request->search) && $request->search!=""){
            // $search = $request->search;
            // $records = $records->where('heading_eng', 'like', '%'.$search.'%')
            //                     ->orWhere('description_eng', 'like', '%'.$search.'%')
            //                     ->orWhere('heading_ar', 'like', '%'.$search.'%')
            //                     ->orWhere('description_ar', 'like', '%'.$search.'%');
        }
        if(isset($request->status) && $request->status!=""){
            $status = $request->status;
            $records = $records->where('status',$request->status);
        }
        $rows = (isset($request->rows) && $request->rows!="") ? $request->rows: 10;
        $records = $rows=="all" ? $records->paginate(9999999)->withQueryString() : $records->paginate($rows)->withQueryString();
        return view('admin.banners.list',compact('records','search','rows','type','status'));
    }

    public function add(Request $request,$type='home'){
        return view('admin.banners.add',compact('type'));
    }

    public function save_new_record(Request $request){
        $validator=Validator::make($request->all(),[
                    'banner'=>'required|image'
        ]);
        if($validator->fails()) {
            return redirect()->back()->withInput()->withErrors($validator->errors());
        }
        else{
            $imageName = "banner-image-".time().'.'.$request->banner->getClientOriginalExtension();
            $result = $request->banner->move(public_path('/admin/images/banner_images'), $imageName);
            $record = Banner::create([
                'banner'=>$imageName,
                'type'=>$request->type,
                'text_eng'=>$request->text_eng ? $request->text_eng: null,
                'text_ar'=>$request->text_ar ? $request->text_ar:null,
                'status'=>1,
            ]);
            $request->session()->flash('success','Banner created Successfully');
            return redirect()->route('admin.list_banners',['type'=>$request->type]);   
        }
    }

    public function changeStatus(Request $request){
        $record = Banner::find($request->id);
        $record->status = $request->status;
        $record->save();
        return true;
    }

    public function delete(Request $request,$type='home',$id){
        $record=Banner::find($id);
        if (File::exists(public_path('/admin/images/banner_images/'.$record->banner))) {
            File::delete(public_path('/admin/images/banner_images/'.$record->banner));
        }

        $record->delete();
        $request->session()->flash('success','Banner Deleted Successfully');
        return redirect()->route('admin.list_banners',['type'=>$type]);
    }

    public function view(Request $request,$id){
        $record = Banner::find($id);
        return view('admin.banners.view',compact('record'));
    }

    public function edit(Request $request,$id){
        $record = Banner::find($id);
        return view('admin.banners.edit',compact('record'));
    }

    public function save_edit_record(Request $request){
        $validator=Validator::make($request->all(),[
            'banner'=>'nullable|image'
        ]);
        if($validator->fails()) {
            return redirect()->back()->withInput()->withErrors($validator->errors());
        }
        else{
            $record = Banner::find($request->id);
            $imageName = $request->old_banner;
            if(isset($request->banner) && !empty($request->banner)){
                $imageName = "banner-image-".time().'.'.$request->banner->getClientOriginalExtension();
                $result = $request->banner->move(public_path('/admin/images/banner_images'), $imageName);
                if (File::exists(public_path('/admin/images/banner_images/'.$request->old_banner))) {
                    File::delete(public_path('/admin/images/banner_images/'.$request->old_banner));
                }
            }
            
            $record->banner = $imageName;
            $record->text_eng = $request->text_eng ? $request->text_eng: null;
            $record->text_ar = $request->text_ar ? $request->text_ar:null;
            $record->save();
            $request->session()->flash('success','Baneer updated Successfully');
            return redirect()->route('admin.list_banners',['type'=>$request->type]);   
        }
    }
}
